/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap;

import fr.arinonia.bootstrap.file.FileManager;
import fr.arinonia.bootstrap.run.JarRunnable;
import fr.arinonia.bootstrap.ui.BootstrapFrame;
import fr.arinonia.bootstrap.ui.BootstrapPanel;
import fr.arinonia.bootstrap.updater.DownloadJob;
import fr.arinonia.bootstrap.updater.DownloadManager;
import fr.arinonia.bootstrap.updater.Updater;
import fr.arinonia.bootstrap.utils.JavaChecker;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Bootstrap {
    public static final Logger LOGGER = Logger.getLogger("Bootstrap");
    private FileManager fileManager;
    private Updater updater;
    private BootstrapFrame frame;
    private BootstrapPanel panel;

    public void start() {
        LOGGER.info("Starting ", Logger.colored("Bonkers", "\u001b[96m"), " v", Logger.colored("1.0.0", "\u001b[96m"));
        try {
            this.preInit();
            this.init();
        }
        catch (Throwable e) {
            String errorMessage = "An error occurred during Bootstrap initialization.\nDetails: " + e + "\nPlease contact technical support with the following information:\n\nStack Trace:\n" + this.getStackTraceAsString(e);
            JOptionPane.showMessageDialog(null, errorMessage, "Erreur", 0);
            LOGGER.error("An error occurred while starting the application: ", e);
        }
    }

    private void preInit() {
        this.fileManager = new FileManager();
        this.fileManager.init();
        JavaChecker javaChecker = new JavaChecker(this.fileManager);
        this.updater = new Updater(this.fileManager);
        this.updater.setNeedJavaUpdate(!javaChecker.check());
    }

    private void init() {
        this.frame = new BootstrapFrame();
        this.panel = new BootstrapPanel(this);
        this.frame.setContentPane(this.panel);
        this.frame.setVisible(true);
        this.panel.setStatus("Initialisation...");
        DownloadJob launcherJob = new DownloadJob("launcher", "", this.panel);
        DownloadManager launcherManager = new DownloadManager("https://bonkers-minecraft.com/api/v1/bootstrap/json/instance.json", launcherJob, this.fileManager.getLauncherFolder());
        this.updater.addJobToDownload(launcherManager);
        Thread updaterThread = new Thread("Updater Thread"){

            @Override
            public void run() {
                try {
                    Bootstrap.this.updater.start(step -> SwingUtilities.invokeLater(() -> Bootstrap.this.panel.setStatus("Downloading Java... (" + (Object)((Object)step) + ")")));
                    Process launcherProcess = new JarRunnable(Bootstrap.this.fileManager).run();
                    if (launcherProcess != null) {
                        Thread.sleep(2000L);
                        if (launcherProcess.isAlive()) {
                            LOGGER.info("Launcher started successfully");
                            SwingUtilities.invokeLater(() -> Bootstrap.this.frame.dispose());
                        } else {
                            LOGGER.error("An error occurred while starting the launcher");
                            JOptionPane.showMessageDialog(null, "An error occurred while starting the launcher", "Error", 0);
                        }
                    } else {
                        LOGGER.error("An error occurred while starting the launcher");
                        JOptionPane.showMessageDialog(null, "An error occurred while starting the launcher", "Error", 0);
                    }
                    this.interrupt();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("An error occurred while updating / stating the launcher", e);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                }
            }
        };
        updaterThread.start();
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public BootstrapFrame getFrame() {
        return this.frame;
    }

    public BootstrapPanel getPanel() {
        return this.panel;
    }
}

