/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.run;

import fr.arinonia.bootstrap.file.FileManager;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JarRunnable {
    private static final Logger logger = Logger.getLogger(JarRunnable.class);
    private final ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);

    public JarRunnable(FileManager fileManager) {
        this.processBuilder.directory(fileManager.getLauncherFolder());
        this.processBuilder.redirectErrorStream(true);
        this.processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        this.processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        List<String> command = this.buildCommand(fileManager);
        this.processBuilder.command(command);
    }

    private List<String> buildCommand(FileManager fileManager) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(fileManager.getJavaExecutablePath());
        String classpath = this.buildClasspath(fileManager);
        if (!classpath.isEmpty()) {
            command.add("-cp");
            command.add(classpath);
            command.add("fr.arinonia.launcher.Main");
        } else {
            command.add("-jar");
            command.add(fileManager.getLauncherFile().getAbsolutePath());
        }
        return command;
    }

    private String buildClasspath(FileManager fileManager) {
        File[] libraries;
        StringBuilder classpath = new StringBuilder();
        classpath.append(fileManager.getLauncherFile().getAbsolutePath());
        File libFolder = new File(fileManager.getLauncherFolder(), "libraries");
        if (libFolder.exists() && libFolder.isDirectory() && (libraries = libFolder.listFiles((dir, name) -> name.endsWith(".jar"))) != null) {
            for (File lib : libraries) {
                String separator = System.getProperty("os.name").toLowerCase().contains("win") ? ";" : ":";
                classpath.append(separator).append(lib.getAbsolutePath());
            }
        }
        return classpath.toString();
    }

    public Process run() throws IOException {
        logger.info("Starting process with command: ", this.processBuilder.command());
        return this.processBuilder.start();
    }
}

