/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.ui;

import fr.arinonia.bootstrap.Bootstrap;
import fr.arinonia.bootstrap.ui.controls.RoundedProgressBar;
import fr.arinonia.bootstrap.ui.theme.ThemeColors;
import fr.arinonia.bootstrap.updater.DownloadJob;
import fr.arinonia.bootstrap.updater.DownloadListener;
import fr.arinonia.bootstrap.utils.ProgressBarHelper;
import fr.arinonia.bootstrap.utils.UiUtil;
import fr.arinonia.bootstrap.utils.Util;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BootstrapPanel
extends JPanel
implements DownloadListener {
    private final RoundedProgressBar roundedProgressBar = new RoundedProgressBar();
    private final JLabel statusUpdate = new JLabel();

    public BootstrapPanel(Bootstrap bootstrap) {
        super(null);
        this.setBackground(ThemeColors.BACKGROUND_PRIMARY);
        Font roboto = this.loadCustomFont();
        this.setupTitle(roboto);
        this.setupWindowControls(bootstrap, roboto);
        this.setupMainImage();
        this.setupProgressBar();
        this.setupStatusLabel(roboto);
    }

    private Font loadCustomFont() {
        try {
            return Font.createFont(0, Bootstrap.class.getResourceAsStream("/font/roboto.ttf"));
        }
        catch (FontFormatException | IOException e) {
            System.err.println("Failed to load custom font, using default");
            return new Font("Segoe UI", 0, 12);
        }
    }

    private void setupTitle(Font roboto) {
        JLabel title = new JLabel("Bonkers");
        title.setForeground(ThemeColors.TEXT_PRIMARY);
        UiUtil.setCustomFont(title, roboto, 42.0f);
        title.setBounds(270 - UiUtil.getLabelWidth(title) / 2, 10, 540, 40);
        this.add(title);
    }

    private void setupWindowControls(final Bootstrap bootstrap, Font roboto) {
        final JLabel close = new JLabel("\u00d7");
        UiUtil.setCustomFont(close, roboto, 30.0f);
        close.setBounds(510, 5, 20, 40);
        close.setForeground(ThemeColors.TEXT_PRIMARY);
        close.setCursor(Cursor.getPredefinedCursor(12));
        close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                close.setForeground(ThemeColors.HOVER_CLOSE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                close.setForeground(ThemeColors.TEXT_PRIMARY);
            }
        });
        this.add(close);
        final JLabel hide = new JLabel("\u2212");
        UiUtil.setCustomFont(hide, roboto, 46.0f);
        hide.setBounds(480, 5, 40, 40);
        hide.setForeground(ThemeColors.TEXT_PRIMARY);
        hide.setCursor(Cursor.getPredefinedCursor(12));
        hide.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                bootstrap.getFrame().setState(1);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                hide.setForeground(ThemeColors.HOVER_MINIMIZE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hide.setForeground(ThemeColors.TEXT_PRIMARY);
            }
        });
        this.add(hide);
    }

    private void setupMainImage() {
        ImageIcon imageIcon = UiUtil.getImageIcon("/image/128x128.png", 256, 256);
        if (imageIcon != null) {
            Image image = imageIcon.getImage();
            JLabel imageLabel = new JLabel();
            imageLabel.setBounds(142, 227, 256, 256);
            imageLabel.setIcon(new ImageIcon(image));
            this.add(imageLabel);
        }
    }

    private void setupProgressBar() {
        this.roundedProgressBar.setBounds(30, 550, 480, 20);
        this.roundedProgressBar.setMinimum(0);
        this.roundedProgressBar.setMaximum(100);
        this.add(this.roundedProgressBar);
    }

    private void setupStatusLabel(Font roboto) {
        this.statusUpdate.setForeground(ThemeColors.TEXT_PRIMARY);
        UiUtil.setCustomFont(this.statusUpdate, roboto, 20.0f);
        this.statusUpdate.setBounds(110, 570, 350, 40);
        this.add(this.statusUpdate);
    }

    public void setStatus(String status) {
        this.statusUpdate.setText(status);
        this.statusUpdate.setBounds(270 - UiUtil.getLabelWidth(this.statusUpdate) / 2, 570, 540, 40);
    }

    public RoundedProgressBar getRoundedProgressBar() {
        return this.roundedProgressBar;
    }

    @Override
    public void onDownloadJobFinished(DownloadJob job) {
        SwingUtilities.invokeLater(() -> this.setStatus("Completed " + job.getPrefix() + " " + job.getName()));
    }

    @Override
    public void onDownloadJobStarted(DownloadJob job) {
        SwingUtilities.invokeLater(() -> this.setStatus("Downloading " + job.getPrefix() + " " + job.getName() + "..."));
    }

    @Override
    public void onDownloadProgress(DownloadJob job, String info) {
        SwingUtilities.invokeLater(() -> {
            this.setStatus("Downloading " + job.getPrefix() + " " + job.getName() + " (" + info + ")");
            this.roundedProgressBar.setValue(Util.crossMult((int)ProgressBarHelper.getDownloadedFiles(), (int)ProgressBarHelper.getTotalFilesNeedToDownload(), 100));
        });
    }
}

