/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.updater;

import fr.arinonia.bootstrap.utils.ProgressBarHelper;
import fr.arinonia.bootstrap.utils.Util;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class DownloadTask {
    private static final Logger LOGGER = Logger.getLogger(DownloadTask.class);
    private final URL url;
    private final File destination;
    private final String hashServer;
    private int nunAttempts = 0;

    public DownloadTask(URL url, File destination, String hashServer) {
        this.url = url;
        this.destination = destination;
        this.hashServer = hashServer;
    }

    public String download() throws IOException {
        String hashLocal = null;
        ++this.nunAttempts;
        if (!this.destination.getParentFile().exists() && !this.destination.getParentFile().mkdirs()) {
            LOGGER.warn("Couldn't create parent directory ", Logger.colored(this.destination.getParentFile().getName(), "\u001b[31m"));
        }
        if (this.destination.isFile()) {
            hashLocal = Util.getMD5(this.destination);
        }
        if (this.destination.isFile() && !this.destination.canWrite()) {
            throw new RuntimeException("Do not have write permissions for " + this.destination + " - aborting!");
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
            connection.setInstanceFollowRedirects(true);
            int status = connection.getResponseCode();
            if (status / 100 == 2) {
                Files.copy(this.catchForbidden(this.url), this.destination.toPath(), new CopyOption[0]);
                ProgressBarHelper.incrementAndGetDownloadedFiles();
                hashLocal = Util.getMD5(this.destination);
                if (this.hashServer.contains("-")) {
                    return "Didn't have hash so assuming our copy is good";
                }
                if (this.hashServer.equalsIgnoreCase(hashLocal)) {
                    return "Downloaded successfully and hash matched";
                }
                throw new IOException(String.format("Hash did not match downloaded MD5 (Hash was %s, downloaded %s)", this.hashServer, hashLocal));
            }
            if (this.destination.isFile()) {
                return "Couldn't connect to server (responded with " + status + ") but have local file, assuming it's good";
            }
            throw new IOException("Server responded with " + status);
        }
        catch (IOException e) {
            if (this.destination.isFile()) {
                return "Couldn't connect to server (" + e.getClass().getSimpleName() + ": '" + e.getMessage() + "') but have local file, assuming it's good";
            }
            throw e;
        }
    }

    private InputStream catchForbidden(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        return connection.getInputStream();
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDestination() {
        return this.destination;
    }

    public String getHashServer() {
        return this.hashServer;
    }

    public int getNunAttempts() {
        return this.nunAttempts;
    }

    public String toString() {
        return "DownloadTask{url=" + this.url + ", destination=" + this.destination + ", hashServer='" + this.hashServer + '\'' + ", nunAttempts=" + this.nunAttempts + '}';
    }
}

