/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.updater;

import com.google.gson.Gson;
import fr.arinonia.bootstrap.file.FileManager;
import fr.arinonia.bootstrap.updater.DownloadJob;
import fr.arinonia.bootstrap.updater.DownloadManager;
import fr.arinonia.bootstrap.updater.models.Data;
import fr.arinonia.bootstrap.updater.models.DataFile;
import fr.arinonia.bootstrap.utils.OperatingSystem;
import fr.arinonia.bootstrap.utils.ProgressBarHelper;
import fr.arinonia.bootstrap.utils.Util;
import fr.arinonia.bootstrap.utils.logger.Logger;
import fr.flowarg.azuljavadownloader.AzulJavaArch;
import fr.flowarg.azuljavadownloader.AzulJavaBuildInfo;
import fr.flowarg.azuljavadownloader.AzulJavaDownloader;
import fr.flowarg.azuljavadownloader.AzulJavaOS;
import fr.flowarg.azuljavadownloader.AzulJavaType;
import fr.flowarg.azuljavadownloader.Callback;
import fr.flowarg.azuljavadownloader.RequestedJavaInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class Updater {
    private static final Logger LOGGER = Logger.getLogger(Updater.class);
    private static final Gson GSON = new Gson();
    private final List<String> ignoredFiles = Collections.synchronizedList(new ArrayList());
    private final Queue<DownloadManager> needToDownload = new LinkedList<DownloadManager>();
    private final FileManager fileManager;
    private boolean fileDeleter = false;
    private boolean isInMaintenance = false;
    private boolean needJavaUpdate = false;

    public Updater(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void start(Callback callback) throws IOException {
        if (this.needJavaUpdate) {
            this.downloadJava(callback);
        }
        int length = this.needToDownload.size();
        for (int i = 0; i < length; ++i) {
            DownloadManager downloadManager = this.needToDownload.poll();
            if (!downloadManager.getFile().exists() && !downloadManager.getFile().mkdirs()) {
                LOGGER.error("Couldn't create directory ", Logger.colored(downloadManager.getFile().getAbsolutePath(), "\u001b[31m"));
            }
            this.jsonDeserialization(Util.getContentURL(downloadManager.getUrl()), downloadManager.getJob(), downloadManager.getFile());
            downloadManager.getJob().getExecutorService().shutdown();
            try {
                downloadManager.getJob().getExecutorService().awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", e);
            }
        }
    }

    private void jsonDeserialization(String jsonContent, DownloadJob job, File folder) {
        Data data = GSON.fromJson(jsonContent, Data.class);
        LOGGER.info("Maintenance: ", data.getMaintenance().isMaintenance(), " for job ", job.getName());
        if (data.getMaintenance().isMaintenance()) {
            this.isInMaintenance = true;
        }
        for (DataFile file : data.getFiles()) {
            File clientFile = new File(folder, file.getPath());
            if (!clientFile.exists() || !clientFile.isFile()) {
                job.addDownloadable(clientFile, file.getHash(), file.getUrl());
                ProgressBarHelper.incrementTotalFilesNeedToDownload();
                this.ignoredFiles.add(clientFile.getAbsolutePath());
                continue;
            }
            try {
                if (!Util.getMD5(clientFile).equals(file.getHash())) {
                    job.addDownloadable(clientFile, file.getHash(), file.getUrl());
                    ProgressBarHelper.incrementTotalFilesNeedToDownload();
                    LOGGER.info("File ", Logger.colored(clientFile.getName(), "\u001b[96m"), " is outdated");
                    if (clientFile.delete()) continue;
                    LOGGER.warn("Couldn't delete ", Logger.colored(clientFile.getName(), "\u001b[31m"));
                    continue;
                }
                this.ignoredFiles.add(clientFile.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while checking the file ", e);
            }
        }
        for (String ignore : data.getIgnoredFiles()) {
            File file = new File(folder, ignore);
            if (file.isDirectory()) {
                ArrayList<File> files = Util.listFiles(file);
                for (File f : files) {
                    this.ignoredFiles.add(f.getAbsolutePath());
                }
                continue;
            }
            this.ignoredFiles.add(file.getAbsolutePath());
        }
        if (this.fileDeleter) {
            this.checkingFiles(folder);
        }
        if (!this.isInMaintenance) {
            LOGGER.info("Starting download job ", Logger.colored(job.getName(), "\u001b[33m"));
            job.startDownloading(job.getExecutorService());
        } else {
            LOGGER.error("Can't download files, the server is in maintenance");
        }
    }

    private boolean isIgnored(File file) {
        for (String path : this.ignoredFiles) {
            if (!path.equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void checkingFiles(File folder) {
        ArrayList<File> files = Util.listFiles(folder);
        for (File file : files) {
            if (this.isIgnored(file) || file.delete()) continue;
            LOGGER.warn("Couldn't delete ", Logger.colored(file.getAbsolutePath(), "\u001b[31m"));
        }
    }

    public void downloadJava(Callback callback) throws IOException {
        AzulJavaOS os;
        LOGGER.info("Downloading Java 8 JRE to runtime folder...");
        if (this.fileManager.isJavaRuntimeInstalled()) {
            LOGGER.info("Java 8 runtime already installed at: {}", this.fileManager.getJavaRuntimeFolder().getAbsolutePath());
            return;
        }
        this.fileManager.prepareJavaRuntimeInstallation();
        AzulJavaDownloader downloader = new AzulJavaDownloader(callback);
        Path javaPath = this.fileManager.getRuntimeFolder().toPath();
        callback.onStep(Callback.Step.QUERYING);
        switch (OperatingSystem.getCurrentPlatform()) {
            case WINDOWS: {
                os = AzulJavaOS.WINDOWS;
                break;
            }
            case MACOS: {
                os = AzulJavaOS.MACOS;
                break;
            }
            default: {
                os = AzulJavaOS.LINUX;
            }
        }
        RequestedJavaInfo requestedJavaInfo = new RequestedJavaInfo("8", AzulJavaType.JRE, os, AzulJavaArch.X64).setJavaFxBundled(true);
        AzulJavaBuildInfo buildInfo = downloader.getBuildInfo(requestedJavaInfo);
        Path javaHome = downloader.downloadAndInstall(buildInfo, javaPath);
        File extractedDir = javaHome.toFile();
        File targetDir = this.fileManager.getJavaRuntimeFolder();
        if (!extractedDir.equals(targetDir)) {
            if (targetDir.exists()) {
                this.deleteDirectory(targetDir);
            }
            if (!extractedDir.renameTo(targetDir)) {
                LOGGER.error("Failed to rename {} to {}", extractedDir.getAbsolutePath(), targetDir.getAbsolutePath());
            }
        }
        if (OperatingSystem.getCurrentPlatform() != OperatingSystem.WINDOWS) {
            this.fixJavaExecutablePermissions(targetDir);
        }
        LOGGER.info("Java 8 JRE successfully installed to: {}", targetDir.getAbsolutePath());
    }

    private void fixJavaExecutablePermissions(File javaRuntimeDir) {
        File binDir = new File(javaRuntimeDir, "bin");
        if (!binDir.exists()) {
            LOGGER.warn("Java bin directory not found: {}", binDir.getAbsolutePath());
            return;
        }
        File[] binFiles = binDir.listFiles();
        if (binFiles == null) {
            LOGGER.warn("No files found in Java bin directory");
            return;
        }
        for (File file : binFiles) {
            if (!file.isFile()) continue;
            try {
                ProcessBuilder pb = new ProcessBuilder("chmod", "+x", file.getAbsolutePath());
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    LOGGER.debug("Set executable permission for: {}", file.getName());
                    continue;
                }
                LOGGER.warn("Failed to set executable permission for: {}", file.getName());
            }
            catch (Exception e) {
                LOGGER.warn("Could not set executable permission for {}: {}", file.getName(), e.getMessage());
            }
        }
        LOGGER.info("Fixed Java executable permissions");
    }

    private boolean deleteDirectory(File directory) {
        File[] files;
        if (directory == null || !directory.exists()) {
            return false;
        }
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                this.deleteDirectory(file);
            }
        }
        return directory.delete();
    }

    public void setNeedJavaUpdate(boolean needJavaUpdate) {
        this.needJavaUpdate = needJavaUpdate;
    }

    public void addJobToDownload(DownloadManager downloadManager) {
        this.needToDownload.add(downloadManager);
    }

    public void setFileDeleter(boolean fileDeleter) {
        this.fileDeleter = fileDeleter;
    }

    public List<String> getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public Queue<DownloadManager> getNeedToDownload() {
        return this.needToDownload;
    }

    public boolean isInMaintenance() {
        return this.isInMaintenance;
    }

    public String toString() {
        return "Updater{ignoredFiles=" + this.ignoredFiles + ", needToDownload=" + this.needToDownload + ", fileDeleter=" + this.fileDeleter + ", isInMaintenance=" + this.isInMaintenance + ", needJavaUpdate=" + this.needJavaUpdate + '}';
    }
}

