/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.utils;

import fr.arinonia.bootstrap.file.FileManager;
import fr.arinonia.bootstrap.utils.logger.Logger;
import java.io.File;

public class JavaChecker {
    private static final Logger LOGGER = Logger.getLogger("JavaChecker");
    private final FileManager fileManager;

    public JavaChecker(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public boolean check() {
        boolean javaInstalled = this.checkJavaInstallation();
        boolean javaFXValid = this.isJavaFXValid();
        boolean javaValid = javaInstalled && javaFXValid;
        LOGGER.info("Java Installation: ", javaInstalled ? Logger.colored("OK", "\u001b[32m") : Logger.colored("NO", "\u001b[31m"));
        return javaValid;
    }

    private boolean checkJavaInstallation() {
        File javaFolder = this.fileManager.getJavaRuntimeFolder();
        File jreFolder = new File(javaFolder, "jre");
        if (!jreFolder.exists() || !jreFolder.isDirectory()) {
            LOGGER.error("Java folder doesn't exist or isn't a directory");
            return false;
        }
        File javaBinary = this.fileManager.getJavaExecutable();
        boolean javaBinaryExists = javaBinary.exists();
        if (javaBinaryExists) {
            LOGGER.info("Java binary found at: " + javaBinary.getAbsolutePath());
        } else {
            LOGGER.error("Java binary not found at: " + javaBinary.getAbsolutePath());
        }
        return javaBinaryExists;
    }

    private boolean isJavaFXValid() {
        File javaFolder = this.fileManager.getJavaRuntimeFolder();
        File jreFolder = new File(javaFolder, "jre");
        if (!jreFolder.exists() || !jreFolder.isDirectory()) {
            return false;
        }
        boolean javaFXExists = false;
        File jfxrtJar = new File(jreFolder, "lib" + File.separator + "ext" + File.separator + "jfxrt.jar");
        if (jfxrtJar.exists() && jfxrtJar.isFile()) {
            javaFXExists = true;
            LOGGER.info("JavaFX found at: " + jfxrtJar.getAbsolutePath());
        }
        return javaFXExists;
    }
}

