/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.utils;

public enum OperatingSystem {
    LINUX("linux", "linux", "unix"),
    WINDOWS("windows", "win"),
    MACOS("mac", "macos", "osx", "mac"),
    UNKNOWN("unknown", new String[0]);

    private final String name;
    private final String[] aliases;

    private OperatingSystem(String name, String ... aliases) {
        this.name = name;
        this.aliases = aliases;
    }

    public static OperatingSystem getCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (OperatingSystem os : OperatingSystem.values()) {
            for (String alias : os.aliases) {
                if (!osName.contains(alias)) continue;
                return os;
            }
        }
        return UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

