/*
 * Decompiled with CFR 0.152.
 */
package fr.arinonia.bootstrap.utils.logger;

import fr.arinonia.bootstrap.utils.logger.ColoredText;
import fr.arinonia.bootstrap.utils.logger.LogLevel;
import fr.arinonia.bootstrap.utils.logger.LogLevelInfo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Logger {
    private static final Map<String, Logger> LOGGERS = new ConcurrentHashMap<String, Logger>();
    private static final Map<LogLevel, LogLevelInfo> LOG_COLORS;
    private static final DateTimeFormatter TIME_FORMATTER;
    private static final String TIMESTAMP_COLOR = "\u001b[36m";
    private static final String LOGGER_NAME_COLOR = "\u001b[35m";
    private static final String DEFAULT_MESSAGE_COLOR = "\u001b[37m";
    private static final Object CONSOLE_LOCK;
    private final String name;

    private Logger(String name) {
        this.name = name;
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getSimpleName());
    }

    public static Logger getLogger(String name) {
        return LOGGERS.computeIfAbsent(name, Logger::new);
    }

    public static ColoredText colored(String text, String color) {
        return new ColoredText(text, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LogLevel level, Object ... messageParts) {
        Object object = CONSOLE_LOCK;
        synchronized (object) {
            String timestamp = LocalDateTime.now().format(TIME_FORMATTER);
            LogLevelInfo levelInfo = LOG_COLORS.get((Object)level);
            StringBuilder message = new StringBuilder().append(TIMESTAMP_COLOR).append("[").append(timestamp).append("] ").append(levelInfo.getColor()).append("[").append(level.getPrefix()).append("] ").append(LOGGER_NAME_COLOR).append("[").append(this.name).append("] ");
            for (Object part : messageParts) {
                if (part instanceof ColoredText) {
                    ColoredText coloredText = (ColoredText)part;
                    message.append(coloredText.getColor()).append(coloredText.getText()).append(DEFAULT_MESSAGE_COLOR);
                    continue;
                }
                message.append(DEFAULT_MESSAGE_COLOR).append(part.toString());
            }
            message.append("\u001b[0m");
            if (level == LogLevel.ERROR) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public void info(Object ... messageParts) {
        this.log(LogLevel.INFO, messageParts);
    }

    public void warn(Object ... messageParts) {
        this.log(LogLevel.WARN, messageParts);
    }

    public void error(Object ... messageParts) {
        this.log(LogLevel.ERROR, messageParts);
    }

    public void debug(Object ... messageParts) {
        this.log(LogLevel.DEBUG, messageParts);
    }

    public void success(Object ... messageParts) {
        this.log(LogLevel.SUCCESS, messageParts);
    }

    public void error(String message, Throwable throwable) {
        this.error(message);
        throwable.printStackTrace(System.err);
    }

    static {
        HashMap<LogLevel, LogLevelInfo> colors = new HashMap<LogLevel, LogLevelInfo>();
        colors.put(LogLevel.INFO, new LogLevelInfo(DEFAULT_MESSAGE_COLOR));
        colors.put(LogLevel.WARN, new LogLevelInfo("\u001b[33m"));
        colors.put(LogLevel.ERROR, new LogLevelInfo("\u001b[31m"));
        colors.put(LogLevel.DEBUG, new LogLevelInfo("\u001b[90m"));
        colors.put(LogLevel.SUCCESS, new LogLevelInfo("\u001b[32m"));
        LOG_COLORS = Collections.unmodifiableMap(colors);
        TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        CONSOLE_LOCK = new Object();
    }
}

