/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.azuljavadownloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import fr.flowarg.azuljavadownloader.AzulJavaBuildInfo;
import fr.flowarg.azuljavadownloader.Callback;
import fr.flowarg.azuljavadownloader.RequestedJavaInfo;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowstringer.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;

public class AzulJavaDownloader {
    private static final String API_ENDPOINT_PACKAGES = "https://api.azul.com/metadata/v1/zulu/packages/";
    private static final String API_ENDPOINT_PACKAGE = "https://api.azul.com/metadata/v1/zulu/packages/%s";
    private static final Gson GSON = new GsonBuilder().serializeNulls().disableHtmlEscaping().setPrettyPrinting().create();
    private final Callback callback;

    public AzulJavaDownloader() {
        this.callback = null;
    }

    public AzulJavaDownloader(@NotNull Callback callback) {
        this.callback = callback;
    }

    public AzulJavaBuildInfo getBuildInfo(RequestedJavaInfo requestedJavaInfo) throws IOException {
        if (this.callback != null) {
            this.callback.onStep(Callback.Step.QUERYING);
        }
        try {
            return AzulJavaDownloader.requestPackage(requestedJavaInfo);
        }
        catch (IOException e) {
            throw new IOException("No build info found!", e);
        }
    }

    public Path downloadAndInstall(AzulJavaBuildInfo buildInfo, Path dirPath) throws IOException {
        Path archivePath = dirPath.resolve(buildInfo.getName());
        Path extractedPath = dirPath.resolve(StringUtils.empty(buildInfo.getName(), "." + buildInfo.getArchiveType()));
        if (Files.notExists(extractedPath, new LinkOption[0])) {
            Files.createDirectories(extractedPath, new FileAttribute[0]);
        }
        if (this.callback != null) {
            this.callback.onStep(Callback.Step.DOWNLOADING);
        }
        if (Files.notExists(archivePath, new LinkOption[0]) || !FileUtils.getMD5(archivePath).equalsIgnoreCase(buildInfo.getMd5Hash())) {
            Files.deleteIfExists(archivePath);
            Files.copy(new URL(buildInfo.getDownloadUrl()).openStream(), archivePath, new CopyOption[0]);
        }
        if (this.callback != null) {
            this.callback.onStep(Callback.Step.EXTRACTING);
        }
        if (buildInfo.getArchiveType().equalsIgnoreCase("zip")) {
            AzulJavaDownloader.smartUnzip(dirPath, archivePath);
        } else if (buildInfo.getArchiveType().equalsIgnoreCase("tar.gz")) {
            AzulJavaDownloader.smartDecompressTarArchive(archivePath, dirPath);
        }
        if (this.callback != null) {
            this.callback.onStep(Callback.Step.DONE);
        }
        return extractedPath.toAbsolutePath();
    }

    private static AzulJavaBuildInfo requestPackage(RequestedJavaInfo requestedJavaInfo) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(String.format(API_ENDPOINT_PACKAGE, AzulJavaDownloader.requestPackages(requestedJavaInfo))).openConnection();
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream());){
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            AzulJavaBuildInfo azulJavaBuildInfo = GSON.fromJson(enclosedReader, AzulJavaBuildInfo.class);
            return azulJavaBuildInfo;
        }
    }

    private static String requestPackages(RequestedJavaInfo requestedJavaInfo) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(requestedJavaInfo.buildParams(API_ENDPOINT_PACKAGES)).openConnection();
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream());){
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            JsonArray array = JsonParser.parseReader(new BufferedReader(enclosedReader)).getAsJsonArray();
            String string = array.get(0).getAsJsonObject().get("package_uuid").getAsString();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void smartDecompressTarArchive(Path tarGzFile, Path destinationDir) throws IOException {
        try (InputStream is = Files.newInputStream(tarGzFile, new OpenOption[0]);
             GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(is);
             TarArchiveInputStream tarIn = new TarArchiveInputStream(gzipIn);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextEntry()) != null) {
                OutputStream output;
                block48: {
                    Path path = destinationDir.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(path, new FileAttribute[0]);
                        continue;
                    }
                    if (!Files.notExists(path, new LinkOption[0]) && FileUtils.getFileSizeBytes(path) == entry.getSize()) continue;
                    byte[] data = new byte[4096];
                    output = Files.newOutputStream(path, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        int count;
                        while ((count = tarIn.read(data, 0, 4096)) != -1) {
                            output.write(data, 0, count);
                        }
                        if (output == null) continue;
                        if (throwable == null) break block48;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (output == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    output.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            output.close();
                            throw throwable3;
                        }
                    }
                    try {
                        output.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                output.close();
            }
            return;
        }
    }

    private static void smartUnzip(Path destinationDir, Path zipFile) throws IOException {
        try (ZipFile toUnZip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> enu = toUnZip.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                AzulJavaDownloader.smartUnzip0(destinationDir.resolve(entry.getName()), toUnZip, entry);
            }
        }
    }

    private static void smartUnzip0(Path fl, ZipFile zipFile, ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        if (Files.notExists(fl, new LinkOption[0])) {
            Files.createDirectories(fl.getParent(), new FileAttribute[0]);
        }
        if (Files.notExists(fl, new LinkOption[0]) || FileUtils.getCRC32(fl) != entry.getCrc()) {
            Files.copy(zipFile.getInputStream(entry), fl, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

